<?php
session_start();
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../function.php';

// Simulasi login admin
if (!isset($_SESSION['admin_username'])) {
    $_SESSION['admin_username'] = 'admin';
}

// Check admin authentication
if (!isLoggedIn('admin')) {
    redirect('login.php');
}

// Initialize database
new Db();

// Get statistics
$totalUsers = Db::result("SELECT COUNT(*) as count FROM generator_users");
$totalUsersCount = !isset($totalUsers['error']) ? $totalUsers[0]->count : 0;

$totalCampaigns = Db::result("SELECT COUNT(*) as count FROM campaigns");
$totalCampaignsCount = !isset($totalCampaigns['error']) ? $totalCampaigns[0]->count : 0;

$totalDomains = Db::result("SELECT COUNT(*) as count FROM domains");
$totalDomainsCount = !isset($totalDomains['error']) ? $totalDomains[0]->count : 0;

$totalClicks = Db::result("SELECT SUM(clicks) as total FROM link_report");
$totalClicksCount = !isset($totalClicks['error']) && $totalClicks[0]->total ? $totalClicks[0]->total : 0;

$totalEarnings = Db::result("SELECT SUM(earnings) as total FROM link_report");
$totalEarningsCount = !isset($totalEarnings['error']) && $totalEarnings[0]->total ? $totalEarnings[0]->total : 0;

$totalConversions = Db::result("SELECT SUM(conversions) as total FROM link_report");
$totalConversionsCount = !isset($totalConversions['error']) && $totalConversions[0]->total ? $totalConversions[0]->total : 0;

$recentUsers = Db::result("SELECT * FROM generator_users ORDER BY created_at DESC LIMIT 5");

$today = date('Y-m-d');
$todayStats = Db::result("SELECT SUM(clicks) as clicks, SUM(conversions) as conversions, SUM(earnings) as earnings FROM link_report WHERE date = '$today'");
$todayClicks = !isset($todayStats['error']) && $todayStats[0]->clicks ? $todayStats[0]->clicks : 0;
$todayConversions = !isset($todayStats['error']) && $todayStats[0]->conversions ? $todayStats[0]->conversions : 0;
$todayEarnings = !isset($todayStats['error']) && $todayStats[0]->earnings ? $todayStats[0]->earnings : 0;

$recentPerformance = Db::result("SELECT * FROM link_report ORDER BY date DESC LIMIT 10");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - Link Generator</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
</head>
<body>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-3 sidebar p-3" style="background:#2a5298;color:white; min-height:100vh;">
            <h4 class="text-center">Admin Panel</h4>
            <small class="text-center d-block mb-3">Welcome, <?= htmlspecialchars($_SESSION['admin_username']) ?></small>
            <nav class="nav flex-column">
                <a class="nav-link active text-white" href="dashboard.php"><i class="fas fa-tachometer-alt me-2"></i>Dashboard</a>
                <a class="nav-link text-white" href="users.php"><i class="fas fa-users me-2"></i>User Management</a>
                <a class="nav-link text-white" href="campaigns.php"><i class="fas fa-bullhorn me-2"></i>Campaigns</a>
                <a class="nav-link text-white" href="domains.php"><i class="fas fa-globe me-2"></i>Domains</a>
                <a class="nav-link text-white" href="reports.php"><i class="fas fa-chart-bar me-2"></i>Reports</a>
                <hr class="border-light">
                <a class="nav-link text-white" href="../index.php"><i class="fas fa-external-link-alt me-2"></i>Link Generator</a>
                <a class="nav-link text-white" href="?logout=1"><i class="fas fa-sign-out-alt me-2"></i>Logout</a>
            </nav>
        </div>
        <div class="col-md-9 p-4">
            <h2>Dashboard Overview</h2>
            <div class="row mt-4">
                <div class="col-md-3"><div class="p-3 bg-white rounded shadow">Users: <?= $totalUsersCount ?></div></div>
                <div class="col-md-3"><div class="p-3 bg-white rounded shadow">Campaigns: <?= $totalCampaignsCount ?></div></div>
                <div class="col-md-3"><div class="p-3 bg-white rounded shadow">Clicks: <?= $totalClicksCount ?></div></div>
                <div class="col-md-3"><div class="p-3 bg-white rounded shadow">Earnings: $<?= number_format($totalEarningsCount,2) ?></div></div>
            </div>
        </div>
    </div>
</div>
<?php
if (isset($_GET['logout'])) {
    session_destroy();
    redirect('login.php');
}
?>
</body>
</html>
