<?php
session_start();
require_once '../config.php';
require_once '../functions.php';

// Redirect if already logged in
if (isLoggedIn('admin')) {
    redirect('dashboard.php');
}

$error = '';

// Handle admin login
if ($_POST['action'] ?? '' === 'admin_login') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    if (empty($username) || empty($password)) {
        $error = 'Please enter both username and password';
    } else {
        // Check against default admin or database
        if ($username === 'admin' && $password === $passWd) {
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['admin_username'] = $username;
            redirect('dashboard.php');
        } else {
            $error = 'Invalid admin credentials';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - Link Generator</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .admin-login-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.2);
            overflow: hidden;
            max-width: 400px;
            width: 100%;
        }
        .login-header {
            background: linear-gradient(135deg, #dc2626, #ef4444);
            color: white;
            padding: 2rem;
            text-align: center;
        }
        .form-control {
            border-radius: 12px;
            border: 2px solid #e2e8f0;
            padding: 0.75rem 1rem;
        }
        .btn-admin {
            background: linear-gradient(135deg, #dc2626, #ef4444);
            border: none;
            border-radius: 12px;
            padding: 0.75rem 2rem;
            font-weight: 600;
            color: white;
        }
        .btn-admin:hover {
            background: linear-gradient(135deg, #b91c1c, #dc2626);
            color: white;
        }
    </style>
</head>
<body>
    <div class="admin-login-card">
        <div class="login-header">
            <i class="fas fa-user-shield fa-3x mb-3"></i>
            <h4 class="mb-0">Admin Panel</h4>
            <p class="mb-0 opacity-75">Link Generator System</p>
        </div>
        <div class="p-4">
            <?php if ($error): ?>
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-circle me-2"></i><?= htmlspecialchars($error) ?>
                </div>
            <?php endif; ?>
            
            <form method="POST">
                <input type="hidden" name="action" value="admin_login">
                <div class="mb-3">
                    <label class="form-label">Username</label>
                    <div class="input-group">
                        <span class="input-group-text bg-light">
                            <i class="fas fa-user text-muted"></i>
                        </span>
                        <input type="text" name="username" class="form-control" 
                               value="<?= htmlspecialchars($_POST['username'] ?? '') ?>" 
                               placeholder="Enter admin username" required autofocus>
                    </div>
                </div>
                <div class="mb-4">
                    <label class="form-label">Password</label>
                    <div class="input-group">
                        <span class="input-group-text bg-light">
                            <i class="fas fa-lock text-muted"></i>
                        </span>
                        <input type="password" name="password" class="form-control" 
                               placeholder="Enter admin password" required>
                    </div>
                </div>
                <button type="submit" class="btn btn-admin w-100 mb-3">
                    <i class="fas fa-sign-in-alt me-2"></i>Login to Admin Panel
                </button>
            </form>
            
            <div class="text-center">
                <small class="text-muted">
                    <i class="fas fa-arrow-left me-1"></i>
                    <a href="../index.php" class="text-decoration-none">Back to Link Generator</a>
                </small>
            </div>
            
            <div class="mt-3 p-3 bg-light rounded">
                <small class="text-muted">
                    <strong>Default Login:</strong><br>
                    Username: admin<br>
                    Password: <?= $passWd ?>
                </small>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>