<?php  
$logo = 'logo/logo.png';
$teamName = '';

if (!isset($page)) {
    $page = "";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=1024, initial-scale=1, user-scalable=no">
    <title><?= $teamName; ?> - CUNGCUNGPRUT TEAM</title>
    <meta name="theme-color" content="#6366f1" />

    <!-- Fonts & Icons -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/flag-icon-css/3.5.0/css/flag-icon.min.css">
    
    <!-- CSS Libraries -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/datatables.net-dt@1.13.6/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-datepicker@1.9.0/dist/css/bootstrap-datepicker.min.css">
    
    <!-- Custom Dashboard CSS -->
    <link rel="stylesheet" href="css/dashboard.css">
    
    <style>
        /* Additional custom styles */
        .pulse {
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.05); }
            100% { transform: scale(1); }
        }
        
        .gradient-text {
            background: linear-gradient(135deg, #6366f1, #8b5cf6);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        /* RGB Moving Color Animation */
        @keyframes rgbShift {
            0% {
                color: rgb(255, 0, 0);
            }
            25% {
                color: rgb(0, 255, 0);
            }
            50% {
                color: rgb(0, 0, 255);
            }
            75% {
                color: rgb(255, 0, 255);
            }
            100% {
                color: rgb(255, 0, 0);
            }
        }

        .rgb-moving {
            animation: rgbShift 2s infinite;
            font-weight: 600;
        }

        /* Force Desktop View */
        html, body {
            min-width: 1024px;
            width: 100%;
        }
        
        body {
            overflow-x: auto;
        }

        /* Disable mobile responsiveness */
        @media (max-width: 768px) {
            html, body {
                min-width: 1024px;
            }
            .container {
                min-width: 1024px;
            }
        }
    </style>
</head>

<body>
    <!-- Sidebar -->
    <div class="sidebar" id="sidebar">
        <div class="sidebar-header">
            <img src="<?= $logo; ?>" alt="Logo" class="logo" />
            <div class="brand gradient-text"><?= $teamName; ?></div>
        </div>
        
        <nav class="sidebar-nav">
            <div class="nav-item">
                <a href="dashboard_index.php" class="nav-link <?= ($page == 'dashboard') ? 'active' : ''; ?>">
                    <i class="fas fa-home"></i>
                    <span>Dashboard</span>
                </a>
            </div>
            <div class="nav-item">
                <a href="dashboard_statistics.php" class="nav-link <?= ($page == 'reports') ? 'active' : ''; ?>">
                    <i class="fas fa-chart-line"></i>
                    <span>Perfomance</span>
                </a>
            </div>
            <div class="nav-item">
                <a href="dashboard_statistics.php" class="nav-link <?= ($page == 'statistics') ? 'active' : ''; ?>">
                    <i class="fas fa-analytics"></i>
                    <span>Analytics</span>
                </a>
            </div>
            <div class="nav-item">
                <a href="logout.php" class="nav-link">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </a>
            </div>
        </nav>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Header -->
        <header class="dashboard-header">
            <div class="header-left">
                <button class="sidebar-toggle" id="sidebarToggle">
                    <i class="fas fa-bars"></i>
                </button>
                <h1 class="header-title">
                    <?php
                    switch($page) {
                        case 'dashboard': echo 'Dashboard'; break;
                        case 'reports': echo 'Conversion Reports'; break;
                        case 'statistics': echo 'Performance'; break;
                        case 'users': echo 'User Management'; break;
                        default: echo 'Dashboard'; break;
                    }
                    ?>
                </h1>
            </div>
            
            <div class="header-right ms-auto">
                <div class="d-flex justify-content-end">
                    <span class="text-white small">
                        <i class="fas fa-clock me-1"></i>
                        <?= date('d M Y, H:i'); ?>
                    </span>
                </div>
            </div>
        </header>


        <!-- Page Content -->
        <div class="container-fluid p-4">