<?php
include('config.php');

define('GX_PATH', realpath(__DIR__.'/'));
define('GX_LIB', GX_PATH.'/lib/');

require 'autoload.php';
new Db();

$today = date('Y-m-d');

echo "<h2>Debug - Database Check</h2>";
echo "<p>Today's date: " . $today . "</p>";

// Check total conversions
$totalQ = Db::result("SELECT COUNT(*) as count FROM `conversions`");
echo "<p>Total conversions in DB: " . $totalQ[0]->count . "</p>";

// Check today's conversions
$todayQ = Db::result("SELECT * FROM `conversions` WHERE DATE(`date`) = '{$today}' ORDER BY `id` DESC LIMIT 5");
echo "<p>Today's conversions count: " . count($todayQ) . "</p>";

if (!empty($todayQ) && !isset($todayQ['error'])) {
    echo "<h3>Recent conversions:</h3>";
    echo "<pre>";
    print_r($todayQ);
    echo "</pre>";
} else {
    echo "<p style='color: red;'>No conversions found!</p>";
    
    // Check with LIKE
    $likeQ = Db::result("SELECT * FROM `conversions` WHERE `date` LIKE '%{$today}%' ORDER BY `id` DESC LIMIT 5");
    echo "<p>Using LIKE - Found: " . count($likeQ) . "</p>";
    if (!empty($likeQ) && !isset($likeQ['error'])) {
        echo "<pre>";
        print_r($likeQ);
        echo "</pre>";
    }
}

// Check last 10 conversions regardless of date
echo "<h3>Last 10 conversions in database:</h3>";
$lastQ = Db::result("SELECT * FROM `conversions` ORDER BY `id` DESC LIMIT 10");
echo "<pre>";
print_r($lastQ);
echo "</pre>";
?>
